﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace WorldLab.GeoDataLib
{
    /// template
    ///    r7 — — — — — — — — —
    ///    r6 — — — — — — — — —
    ///    r5 — — — — — — — — —
    /// Y  r4 — — — — — — — — —
    ///    r3 — — — — — P  — — —
    ///    r2 — — — — — — — — —
    ///    r1 — — — — — — — — —
    ///    r0 — — — — — — — — —
    ///    O  c0 c1 c2 c3 c4 c5 c6 c7 c8
    ///                   X
    /// cell P(r3,c5)
    public class TemplateCell
    {
        /// row number
        private int row;

        /// column number
        private int col;

        /// is in window
        private bool isInWindow;

        /// distance to the center of template
        private double disToCentre;

        /// influence value to the center of template
        private double influence;
        
        /// row number
        public int Row
        {
            get
            {
                return row;
            }
            set
            {
                row = value;
            }
        }

        /// column number
        public int Col
        {
            get
            {
                return col;
            }
            set
            {
                col = value;
            }
        }
        
        /// is in window
        public bool IsInWindow
        {
            get
            {
                return isInWindow;
            }
            set
            {
                isInWindow = value;
            }
        }

        
        /// distance to the center of template
        public double DisToCentre
        {
            get
            {
                return disToCentre;
            }
            set
            {
                disToCentre = value;
            }
        }

        
        /// influence value to the center of template
        public double Influence
        {
            get
            {
                return influence;
            }
            set
            {
                influence = value;
            }
        }
        
        public TemplateCell()
        {
            row = 0;
            col = 0;
            isInWindow = false;
            disToCentre = double.NaN;
        }

        public TemplateCell(int r, int c, bool b, double dis)
        {
            row = r;
            col = c;
            isInWindow = b;
            disToCentre = dis;
        }
    }



    /// template of rectangle window
    ///    r7 — — — — — — — — —
    ///    r6 — — — — — — — — —
    ///    r5 — — — — — — — — —
    /// Y  r4 — — — — — — — — —
    ///    r3 — — — — — — — — —
    ///    r2 — — — — — — — — —
    ///    r1 — — — — — — — — —
    ///    r0 — — — — — — — — —
    ///    O  c0 c1 c2 c3 c4 c5 c6 c7 c8
    ///                   X
    public class RectWndTemplate
    {
        /// row number
        private int rowCounts;

        /// column number
        private int colCounts;

        /// row number of center point
        private int centreRow;

        /// column number of center point
        private int centreCol;

        /// cells array
        private TemplateCell[] cells;

        /// row number
        public int RowCounts
        {
            get
            {
                return rowCounts;
            }
            set
            {
                rowCounts = value;
            }
        }

        /// column number
        public int ColCounts
        {
            get
            {
                return colCounts;
            }
            set
            {
                colCounts = value;
            }
        }

        /// row number of center point
        public int CentreRow
        {
            get
            {
                return centreRow;
            }
            set
            {
                centreRow = value;
            }
        }

        /// column number of center point
        public int CentreCol
        {
            get
            {
                return centreCol;
            }
            set
            {
                centreCol = value;
            }
        }

        /// cells array
        public TemplateCell[] Cells
        {
            get
            {
                return cells;
            }
            set
            {
                cells = value;
            }
        }

        private bool Init(int rows, int cols)
        {
            int nSize = rows * cols;
            if (nSize <= 0)
            {
                return false;
            }

            cells = new TemplateCell[nSize];

            return true;
        }

        public RectWndTemplate()
		{
            rowCounts = 0;
            colCounts = 0;
            centreRow = 0;
            centreCol = 0;
			Init(0, 0);
		}

		public RectWndTemplate(int rows, int cols)
		{
            rowCounts = rows;
            colCounts = cols;
            centreRow = rows / 2;
            centreCol = cols / 2;
            Init(rows, cols);
		}

        public TemplateCell GetElement(int row, int col) 
		{
            if (row < 0 || row >= rowCounts || col < 0 || col >= colCounts)
            {
                return null;
            }
            else
            {
                return cells[row * colCounts + col];
            }
		}

        public bool SetElement(int row, int col, TemplateCell cell)
        {
            if (row < 0 || row >= rowCounts || col < 0 || col >= colCounts)
            {
                return false;
            }
            else
            {
                cells[row * colCounts + col] = cell;
                return true;
            }
        }

    }

}
